<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SmartVend Pro</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">

    <!-- Header -->
    <header class="bg-white shadow-sm sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">SmartVend Pro</h1>
                <p class="text-sm text-gray-500">Select your favorite items</p>
            </div>
            <button class="bg-purple-600 hover:bg-purple-700 text-white px-6 py-2 rounded-lg font-medium flex items-center transition-colors duration-200">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
                View Cart
            </button>
        </div>
    </header>

    <!-- Main Content -->
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            
            <!-- Product 1 -->
            <div class="bg-white rounded-2xl shadow-sm hover:shadow-md transition-shadow duration-300 overflow-hidden flex flex-col p-4">
                <div class="relative w-full h-64 rounded-xl overflow-hidden mb-4">
                     <img src="<?= base_url('assets/product1.png') ?>" alt="Fresh Orange Juice" class="w-full h-full object-cover transform hover:scale-105 transition-transform duration-500">
                </div>
                <div class="flex-1 flex flex-col">
                    <h2 class="text-lg font-bold text-gray-900 mb-1">Fresh Orange Juice</h2>
                    <p class="text-gray-500 text-sm mb-4">Pure and refreshing, cold-pressed from premium oranges</p>
                    
                    <div class="mt-auto">
                        <div class="text-2xl font-bold text-blue-600 mb-4">₹149.00</div>
                        <button class="w-full bg-green-500 hover:bg-green-600 text-white py-3 rounded-lg font-medium flex justify-center items-center transition-colors duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                            </svg>
                            Add to Cart
                        </button>
                    </div>
                </div>
            </div>

            <!-- Product 2 -->
            <div class="bg-white rounded-2xl shadow-sm hover:shadow-md transition-shadow duration-300 overflow-hidden flex flex-col p-4">
                 <div class="relative w-full h-64 rounded-xl overflow-hidden mb-4">
                     <img src="<?= base_url('assets/product2.png') ?>" alt="Crispy Potato Chips" class="w-full h-full object-cover transform hover:scale-105 transition-transform duration-500">
                </div>
                <div class="flex-1 flex flex-col">
                    <h2 class="text-lg font-bold text-gray-900 mb-1">Crispy Potato Chips</h2>
                    <p class="text-gray-500 text-sm mb-4">Perfectly salted and crispy, the ultimate snack choice</p>
                    
                    <div class="mt-auto">
                        <div class="text-2xl font-bold text-blue-600 mb-4">₹99.00</div>
                         <button class="w-full bg-green-500 hover:bg-green-600 text-white py-3 rounded-lg font-medium flex justify-center items-center transition-colors duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                            </svg>
                            Add to Cart
                        </button>
                    </div>
                </div>
            </div>

        </div>
    </main>

</body>
</html>
