<?php

namespace App\Controllers;

use CodeIgniter\RESTful\ResourceController;

class SwitchController extends ResourceController
{
    protected $format = 'json';
    private $file;

    public function __construct()
    {
        $this->file = WRITEPATH . 'switch.txt';

        if (!file_exists($this->file)) {
            file_put_contents($this->file, 'off');
        }
    }

    public function index()
    {
        return view('switch_view');
    }

    // ON / OFF
    public function toggle($status)
    {
        $state = ($status === 'on') ? 'on' : 'off';

        file_put_contents($this->file, $state);

        return $this->respond([
            'status' => $state
        ]);
    }

    // COMPLETE
    public function complete()
    {
        file_put_contents($this->file, 'complete');

        return $this->respond([
            'status' => 'complete'
        ]);
    }

    // STATUS API → returns ONLY ONE value
    public function status()
    {
        $state = trim(file_get_contents($this->file));

        return $this->respond([
            'status' => $state
        ]);
    }
}
