<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Switch Control</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>body { font-family: 'Inter', sans-serif; }</style>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center">

    <div class="bg-white p-8 rounded-xl shadow-lg text-center max-w-sm w-full">
        <h1 class="text-2xl font-bold mb-6 text-gray-800">Control Panel</h1>
        
        <div class="flex space-x-4 justify-center mb-8">
            <button onclick="toggleSwitch('on')" class="bg-green-500 hover:bg-green-600 text-white font-bold py-3 px-8 rounded-lg transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-opacity-50">
                ON
            </button>
            <button onclick="toggleSwitch('off')" class="bg-red-500 hover:bg-red-600 text-white font-bold py-3 px-8 rounded-lg transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-opacity-50">
                OFF
            </button>
        </div>

        <div id="response-area" class="hidden p-4 rounded-lg bg-gray-50 border border-gray-200">
            <p class="text-sm text-gray-500 mb-1">API Response:</p>
            <p id="api-result" class="text-xl font-mono font-bold text-blue-600">--</p>
        </div>
    </div>

    <script>
        function toggleSwitch(status) {
            const xhr = new XMLHttpRequest();
            const url = `<?= base_url('/api/switch/') ?>${status}`;
            
            xhr.open('GET', url, true);
            
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    const resultElement = document.getElementById('api-result');
                    const responseArea = document.getElementById('response-area');
                    
                    if (xhr.status === 200) {
                        try {
                            const data = JSON.parse(xhr.responseText);
                            resultElement.textContent = data.result.toUpperCase();
                            responseArea.classList.remove('hidden');
                            
                            // Visual feedback
                            if (data.result === 'on') {
                                resultElement.className = "text-xl font-mono font-bold text-green-600";
                            } else {
                                resultElement.className = "text-xl font-mono font-bold text-red-600";
                            }
                        } catch (e) {
                            console.error('Response was not JSON:', xhr.responseText);
                            alert('Server returned invalid JSON. Check console for details.');
                        }
                    } else {
                        console.error('Request failed. Status:', xhr.status);
                        alert('Request failed. Status: ' + xhr.status + '\nResponse: ' + xhr.responseText.substring(0, 50));
                    }
                }
            };
            
            xhr.send();
        }
    </script>
</body>
</html>
